/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.dev.designgridlayout.BarRowItem;
import net.java.dev.designgridlayout.Tag;

final class PlatformHelper {
    private static final String BUTTON_TAGS = "LRHYN<>FACOX_";
    private static final String TAGS_GROUP = "([LRHYN<>FACOX_]*)";
    private static final String PARSER = "^([LRHYN<>FACOX_]*)/([LRHYN<>FACOX_]*)/([LRHYN<>FACOX_]*)$";
    private static String _leftTags = null;
    private static String _centerTags = null;
    private static String _rightTags = null;

    private PlatformHelper() {
    }

    static int getDefaultAlignment() {
        switch (PlatformHelper.platform()) {
            case MACINTOSH: {
                return 11;
            }
        }
        return 10;
    }

    static List<BarRowItem> extractLeftItems(List<BarRowItem> items) {
        PlatformHelper.initButtonsTagOrder();
        return PlatformHelper.extractItems(items, _leftTags);
    }

    static List<BarRowItem> extractCenterItems(List<BarRowItem> items) {
        PlatformHelper.initButtonsTagOrder();
        return PlatformHelper.extractItems(items, _centerTags);
    }

    static List<BarRowItem> extractRightItems(List<BarRowItem> items) {
        PlatformHelper.initButtonsTagOrder();
        return PlatformHelper.extractItems(items, _rightTags);
    }

    private static List<BarRowItem> extractItems(List<BarRowItem> items, String tags) {
        ArrayList<BarRowItem> extractedItems = new ArrayList<BarRowItem>(items.size());
        for (int i = 0; i < tags.length(); ++i) {
            char code2 = tags.charAt(i);
            if (code2 == '_') {
                extractedItems.add(null);
                continue;
            }
            PlatformHelper.addItems(extractedItems, items, Tag.fromCode(code2));
        }
        PlatformHelper.removeExtraGaps(extractedItems);
        return extractedItems;
    }

    private static void removeExtraGaps(List<BarRowItem> items) {
        Iterator<BarRowItem> iterator2 = items.iterator();
        BarRowItem previous = null;
        boolean first = true;
        while (iterator2.hasNext()) {
            BarRowItem current = iterator2.next();
            if (current == null && previous == null && !first) {
                iterator2.remove();
            }
            previous = current;
            first = false;
        }
        if (!items.isEmpty() && items.get(0) == null) {
            items.remove(0);
        }
        if (!items.isEmpty() && items.get(items.size() - 1) == null) {
            items.remove(items.size() - 1);
        }
    }

    private static void addItems(List<BarRowItem> target, List<BarRowItem> source, Tag tag) {
        boolean previousItemWasAdded = false;
        for (BarRowItem item : source) {
            if (item == null) {
                if (previousItemWasAdded) {
                    target.add(null);
                }
                previousItemWasAdded = false;
                continue;
            }
            if (item.tag() == tag) {
                target.add(item);
                previousItemWasAdded = true;
                continue;
            }
            previousItemWasAdded = false;
        }
    }

    private static void initButtonsTagOrder() {
        if (_leftTags == null) {
            String tagsOrder;
            switch (PlatformHelper.platform()) {
                case MACINTOSH: {
                    tagsOrder = "L_H/X/NY<>F_COA_R";
                    break;
                }
                case LINUX: {
                    tagsOrder = "L_H//XNYAC<>FO_R";
                    break;
                }
                default: {
                    tagsOrder = "L_/X/YN<>F_OCAH_R";
                }
            }
            PlatformHelper.initButtonsTagOrder(tagsOrder);
        }
    }

    static void initButtonsTagOrder(String order) {
        Pattern parser = Pattern.compile(PARSER);
        Matcher matcher2 = parser.matcher(order);
        if (!matcher2.matches()) {
            throw new IllegalArgumentException("Order `" + order + "` doesn't follow required pattern");
        }
        _leftTags = PlatformHelper.group(matcher2, 1);
        _centerTags = PlatformHelper.group(matcher2, 2);
        _rightTags = PlatformHelper.group(matcher2, 3);
    }

    private static String group(Matcher matcher2, int group2) {
        String result2 = matcher2.group(group2);
        return result2 == null ? "" : result2;
    }

    private static Platform platform() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS")) {
            return Platform.MACINTOSH;
        }
        if (os.startsWith("Linux")) {
            return Platform.LINUX;
        }
        if (os.startsWith("Windows")) {
            return Platform.WINDOWS;
        }
        return Platform.OTHER;
    }

    private static enum Platform {
        WINDOWS,
        MACINTOSH,
        LINUX,
        OTHER;

    }
}

